#include "stdafx.h" 
#include "windows.h"
#include "wsparciekluczy.h"

void ZmodyfikujKod(void *addr, int rozmiarKodu, char *hasloWWW) 
{
	char * kluczAktywacji = OdczytajKluczAktywacji(hasloWWW);

	// Odczyt klucza programowego
	char * kluczProgramowy = new char[rozmiarKodu];
	FILE* f;
	fopen_s(&f, "klucz_programowy.dat", "r");
	fread_s(kluczProgramowy, rozmiarKodu, sizeof(char), rozmiarKodu, f);
	fclose(f);

	// deszyfracja klucza programowego
	int indeksKlucza = 0;
	for(int i = 0; i < rozmiarKodu; i++)
	{
		kluczProgramowy[i] = kluczProgramowy[i] ^ kluczAktywacji[indeksKlucza++];
		if(indeksKlucza >= MAX_KLUCZ)
			indeksKlucza = 0;
	}
   
    //wprowadzenie klucza do kodu
	HANDLE h = OpenProcess(PROCESS_VM_OPERATION|PROCESS_VM_WRITE, true, GetCurrentProcessId()); 
	WriteProcessMemory(h, addr, kluczProgramowy, rozmiarKodu, NULL); 
	CloseHandle(h);		
	delete kluczProgramowy;
	delete kluczAktywacji;
} 

void PobierzKod(void *addr, int rozmiarKodu) 
{
	char * bufor = new char[rozmiarKodu];
	SIZE_T przeczytano = 0;

	HANDLE h = OpenProcess(PROCESS_VM_OPERATION|PROCESS_VM_READ, true, GetCurrentProcessId()); 
	ReadProcessMemory(h, addr, (void*)bufor, rozmiarKodu, &przeczytano);
	CloseHandle(h);

	if(przeczytano != rozmiarKodu)
		printf("Nie udao si wykona zrzutu");
	else
	{
		FILE *plik;
		fopen_s(&plik, "klucz_programowy.dat",  "wb");
		fwrite(bufor, sizeof(char), przeczytano, plik);
		fclose(plik);
	}

	delete bufor;
}


